<?php
include("db.php");

// Create a debug log array
$debug_log = [];
$debug_log[] = "PHP script execution started.";

// --- Session Configuration ---
session_set_cookie_params(7 * 24 * 60 * 60);
session_start();
$debug_log[] = "Session started. Session ID: " . session_id();

// --- CORS and Content-Type Headers ---
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // Be specific in production
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");


// Handle OPTIONS pre-flight request for CORS
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit();
}


// Your Auth0 Config and JWT validation function remain the same
define('AUTH0_DOMAIN', 'dev-wuyvsaj3q23mnoky.us.auth0.com');
define('AUTH0_CLIENT_ID', 'Ec7YOLEsizkHNaxPLrFjjZVYxIxBQGSi');
function validateAuth0JWT($jwt) { /* ... your full function ... */ 
    $tks = explode('.', $jwt);
    if (count($tks) != 3) { return false; }
    list($headb64, $payloadb64, $cryptob64) = $tks;
    $header = json_decode(base64_decode(strtr($headb64, '-_', '+/')), true);
    $payload = json_decode(base64_decode(strtr($payloadb64, '-_', '+/')), true);
    if ($payload['iss'] !== 'https://'.AUTH0_DOMAIN.'/') { return false; }
    if ($payload['aud'] !== AUTH0_CLIENT_ID) { return false; }
    if (isset($payload['exp']) && $payload['exp'] < time()) { return false; }
    $jwks = json_decode(file_get_contents('https://'.AUTH0_DOMAIN.'/.well-known/jwks.json'), true);
    $key = null;
    foreach ($jwks['keys'] as $k) {
        if ($k['kid'] === $header['kid']) {
            $key = openssl_pkey_get_public("-----BEGIN PUBLIC KEY-----\n".wordwrap($k['x5c'][0], 64, "\n", true)."\n-----END PUBLIC KEY-----");
            break;
        }
    }
    if (!$key) return false;
    $signature = base64_decode(strtr($cryptob64, '-_', '+/'));
    $data = "$headb64.$payloadb64";
    $valid = openssl_verify($data, $signature, $key, 'SHA256');
    return $valid === 1 ? $payload : false;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);
    $debug_log[] = "Received POST request. Body: " . $rawData;

    // --- START OF CRITICAL FIX ---
    // More reliable way to get the Authorization header
    $authHeader = null;
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
        $debug_log[] = "Authorization header found in \$_SERVER['HTTP_AUTHORIZATION'].";
    } elseif (function_exists('getallheaders')) {
        $allHeaders = getallheaders();
        // Header keys are case-insensitive in getallheaders()
        if (isset($allHeaders['Authorization'])) {
            $authHeader = $allHeaders['Authorization'];
            $debug_log[] = "Authorization header found via getallheaders().";
        }
    }
    // --- END OF CRITICAL FIX ---

    // Auth0 Login Path
    if ($authHeader !== null) { // Use the variable we just defined
        $debug_log[] = "Processing as Auth0 login.";
        $token = str_replace('Bearer ', '', $authHeader);
        $payload = validateAuth0JWT($token);
        
        if (!$payload) {
            $debug_log[] = "Auth0 JWT validation FAILED.";
            echo json_encode(['status' => 'error', 'message' => 'Invalid token', 'debug' => $debug_log]);
            exit();
        }
        
        $debug_log[] = "Auth0 JWT validation successful.";
        $email = $payload['email'] ?? $payload['sub']; // Use email, fallback to subject
        $debug_log[] = "Looking for user with email/sub: " . $email;
        
        $sql = "SELECT id, displayname, email FROM customer WHERE delete_status = 0 AND email = '".$conn->real_escape_string($email)."'";
        $result = $conn->query($sql);
        
        if ($result->num_rows === 0) {
            $debug_log[] = "Auth0 user not found in local database.";
            echo json_encode(['status' => 'error', 'message' => 'Account not found. Please register first.', 'debug' => $debug_log]);
            exit();
        }
        
        $user = $result->fetch_assoc();
        $debug_log[] = "User found in DB. ID: " . $user['id'];
        
        $_SESSION['user'] = [
            'user_id' => $user['id'],
            'username' => $user['displayname'],
            'email' => $user['email']
        ];
        $debug_log[] = "Session created for user: " . json_encode($_SESSION['user']);
        
        // Use a more specific INSERT statement
        $insertSql = "INSERT INTO sign_in (User_id, Name, In_Time, In_Date, Delete_status) VALUES ('{$user['id']}', '{$conn->real_escape_string($user['displayname'])}', NOW(), CURDATE(), 0)";
        $conn->query($insertSql);
        
        echo json_encode([
            'status' => 'success',
            'message' => 'Login successful',
            'data' => $_SESSION['user'],
            'debug' => $debug_log
        ]);

    }
    // Existing Email/Password Login Path
    else {
        $debug_log[] = "No Authorization header found. Processing as standard email/password login.";
        // ... your existing email/password logic ...
        // This part is now correctly skipped during an Auth0 login.
        $email = isset($data['email']) ? $conn->real_escape_string(trim($data['email'])) : '';
        $password = isset($data['password']) ? trim($data['password']) : '';
        
        if (empty($email) || empty($password)) {
            echo json_encode(['status' => 'error', 'message' => 'Email and password are required', 'debug' => $debug_log]);
            exit();
        }
        // ... rest of your standard login code
        $sql = "SELECT id, displayname, email, password FROM customer WHERE delete_status = 0 AND email = '$email' LIMIT 1";
        $result = $conn->query($sql);
        if ($result->num_rows === 0) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid email or password', 'debug' => $debug_log]);
            exit();
        }
        $user = $result->fetch_assoc();
        if ($password === $user['password']) {
            $_SESSION['user'] = [ 'user_id' => $user['id'], 'username' => $user['displayname'], 'email' => $user['email'] ];
            $insertSql = "INSERT INTO sign_in (User_id, Name, In_Time, In_Date, Delete_status) VALUES ('{$user['id']}', '{$conn->real_escape_string($user['displayname'])}', NOW(), CURDATE(), 0)";
            $conn->query($insertSql);
            echo json_encode([ 'status' => 'success', 'message' => 'Login successful', 'data' => $_SESSION['user'], 'debug' => $debug_log ]);
        } else {
            echo json_encode([ 'status' => 'error', 'message' => 'Invalid email or password', 'debug' => $debug_log ]);
        }
    }
} 
// ... your GET and other handlers
else {
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
}
$conn->close();
?>